/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWAttachmentType;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWMilestoneDefinition;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWReplyInstruction;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWRuleSetDefinition;
import filenet.vw.api.VWSchema;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowRuntimeId;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import filenet.vw.base.XMLHelper;
import filenet.vw.base.exprcomp.IField;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VWWorkflowDefinition
extends VWMLABase
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 119123L;
    private String description = null;
    private VWWorkflowCollectionDefinition myWorkflowCollection = null;
    private String subject = null;
    protected String name = "";
    private VWMapDefinition[] maps = null;
    private VWArrayHandler mapsHandler = new VWArrayHandler();
    protected static final String MAIN_MAP_NAME = "Workflow";
    private String mainAttachmentName = null;
    private String baseWorkClassName = null;
    private String rosterName = null;
    private String eventLogName = null;
    private String authorTool = null;
    private ArrayList<String> otherAuthorTools = new ArrayList(1);
    private String tag = null;
    private VWFieldDefinition[] fields = null;
    private VWArrayHandler fieldsHandler = new VWArrayHandler();
    private long deadline = 0L;
    private long reminder = 0L;
    private boolean disableEmailNotification = false;
    private VWMilestoneDefinition[] milestones = null;
    private VWArrayHandler milestonesHandler = new VWArrayHandler();
    private VWPartnerLinkDefinition[] partnerLinks = null;
    private VWArrayHandler partnerLinkHandler = new VWArrayHandler();
    private VWSchema[] schemas = null;
    private VWArrayHandler schemaHandler = new VWArrayHandler();
    private VWRuleSetDefinition[] ruleSets = null;
    private VWArrayHandler ruleSetsHandler = new VWArrayHandler();
    protected VWAttributeInfo attributes = null;
    protected VWWorkflowRuntimeId runtimeId = null;
    private String incomingWSAttachmentFolder = null;
    private boolean versionAgnostic = false;
    private boolean validateUsingSchema = true;
    private boolean validateFlag = true;
    private boolean transferFlag = true;
    protected String originalId = null;
    public static final int LVALUE = 0;
    public static final int RVALUE = 1;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-11-18 00:46:36 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/PUI_510_Int/1 $";
    }

    public VWWorkflowDefinition() throws VWException {
        this.createMap(MAIN_MAP_NAME);
        this.createFieldNoValidateName("F_Trackers", "{\"\"}", 64, true);
        this.getField("F_Trackers").setMergeType(4);
    }

    protected VWWorkflowDefinition(boolean notUsed) throws VWException {
    }

    public VWValidationError[] validate(VWSession theSession, boolean fixupSteps) throws VWException {
        return this.validate(theSession, null, null);
    }

    public VWValidationError[] validate(VWSession theSession, VWSystemConfiguration theSystemConfig, String sdfFileContents) throws VWException {
        VWValidationContext validationHelper = new VWValidationContext(theSession, theSystemConfig, sdfFileContents);
        return this.validate(validationHelper);
    }

    protected VWValidationError[] validate(VWValidationContext validationContext) throws VWException {
        VWWorkflowDefinition flatWF;
        VWPartnerLinkDefinition[] pls;
        VWSchema[] ss;
        VWMilestoneDefinition[] mls;
        VWMapDefinition[] maps;
        VWFieldDefinition[] fields;
        VWValidationError theError;
        VWString theMessage;
        VWValidationError theError2;
        VWString theMessage2;
        VWValidationError theError3;
        VWString theMessage3;
        String[] theErrorStrings;
        VWCompiledExpr compRes;
        VWValidationError theError4;
        VWString theMessage4;
        validationContext.resetValidationErrorList();
        if (this.name == null || this.name.length() == 0) {
            VWString theMessage5 = new VWString("vw.api.VWWorkflowDefinitionNullOrEmptyName", "The name of the workflow definition is null or empty.  Name is used to generate the WorkClass name at transfer time, so it must have a value.");
            VWValidationError theError5 = new VWValidationError(6, 1, null, null, theMessage5.toString(), null);
            validationContext.addValidationError(theError5);
        } else {
            VWQueueDefinition queueDef = null;
            try {
                queueDef = validationContext.getQueueDefinition(this.name);
            }
            catch (VWException ex) {
                // empty catch block
            }
            if (queueDef != null) {
                theMessage4 = new VWString("vw.api.VWWorkflowDefinitionNameSameAsExistingQueueName", "The name of the workflow definition, {0}, is already being used as a Queue name on the server, please choose a different workflow name for your workflow definition.", this.name);
                theError4 = new VWValidationError(6, 1, this.name, null, theMessage4.toString(), null);
                validationContext.addValidationError(theError4);
            }
            if (this.name.compareTo(this.getBaseWorkClassName()) == 0) {
                theMessage4 = new VWString("vw.api.VWWorkflowDefinitionNameEqualsBaseName", "The name of the workflow, \"{0}\", is the same as the base workflow name.", this.name);
                theError4 = new VWValidationError(6, 1, this.name, null, theMessage4.toString(), null);
                validationContext.addValidationError(theError4);
            }
            this.findInheritanceProblem(this.getBaseWorkClassName(), validationContext);
        }
        VWWorkflowSignature myWflSignature = this.getWorkflowSignature(validationContext);
        if (this.subject != null) {
            compRes = new VWCompiledExpr();
            theErrorStrings = VWExpr.compileVWExpr(this.subject, myWflSignature, this.getBaseWorkflowSignature(validationContext), null, null, false, compRes);
            if (theErrorStrings != null || compRes.getResultIsArray() || compRes.getResultType() != 2 || this.subject.trim().charAt(0) != '\"' && this.subject.trim().charAt(0) != '\'') {
                theMessage3 = new VWString("vw.api.VWWorkflowDefinitionSubjectNotStringLiteral", "Subject must be a quoted string literal expression, it''s either missing quotes or some other syntax error was found.");
                theError3 = new VWValidationError(6, 1, this.subject, null, theMessage3.toString(), null);
                validationContext.addValidationError(theError3);
            }
        }
        if (this.rosterName != null) {
            VWRosterDefinition aRoster = null;
            try {
                aRoster = validationContext.getRosterDefinition(this.rosterName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (aRoster == null) {
                theMessage2 = new VWString("vw.api.VWWorkflowDefinitionRosterDoesNotExist", "Either the roster, {0}, does not exist, or it is not valid for this logon session.  Select a different roster, or use the configuration tool to create the roster, or give the user permission to use the roster.", this.rosterName);
                theError2 = new VWValidationError(6, 1, this.getName(), this.rosterName, theMessage2.toString(), null);
                validationContext.addValidationError(theError2);
            }
        }
        if (this.eventLogName != null) {
            VWLogDefinition aLog = null;
            try {
                aLog = validationContext.getLogDefinition(this.eventLogName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (aLog == null) {
                theMessage2 = new VWString("vw.api.VWWorkflowDefinitionEventLogDoesNotExist", "The event log {0} does not exist, or it is not valid for this logon session.  Select a different event log, or use the configuration tool to create the event log, or give the user permission to use the event log.", this.eventLogName);
                theError2 = new VWValidationError(6, 1, this.getName(), this.eventLogName, theMessage2.toString(), null);
                validationContext.addValidationError(theError2);
            }
        }
        if (this.tag != null && this.tag.compareTo("") != 0) {
            compRes = new VWCompiledExpr();
            theErrorStrings = VWExpr.compileVWExpr(this.tag, myWflSignature, this.getBaseWorkflowSignature(validationContext), null, null, true, compRes);
            if (theErrorStrings != null) {
                int errorCount = theErrorStrings.length;
                for (int i = 0; i < errorCount; ++i) {
                    VWString theMessage6 = new VWString("vw.api.VWWorkflowDefinitionTagSyntaxError", "{0}", theErrorStrings[i]);
                    VWValidationError theError6 = new VWValidationError(6, 1, this.tag, null, theMessage6.toString(), null);
                    validationContext.addValidationError(theError6);
                }
            } else if (compRes.getResultIsArray()) {
                theMessage3 = new VWString("vw.api.VWWorkflowDefinitionTagIsArray", "the tag expression <{0}> is an array", this.tag);
                theError3 = new VWValidationError(6, 1, this.tag, null, theMessage3.toString(), null);
                validationContext.addValidationError(theError3);
            }
        }
        if (this.deadline > 0L) {
            // empty if block
        }
        if (this.reminder > 0L && this.reminder > this.deadline) {
            theMessage4 = new VWString("vw.api.VWWorkflowDefinitionReminderTooBig", "The Reminder value for the workflow is larger than the Deadline value.");
            theError4 = new VWValidationError(6, 1, this.name, null, theMessage4.toString(), null);
            validationContext.addValidationError(theError4);
        }
        if (this.mainAttachmentName != null) {
            int firstQuoteIdx = this.mainAttachmentName.indexOf(34);
            int lastQuoteIdx = this.mainAttachmentName.lastIndexOf(34);
            if (firstQuoteIdx == -1 || lastQuoteIdx == -1 || firstQuoteIdx == lastQuoteIdx) {
                VWString theMessage7 = new VWString("vw.api.VWWorkflowDefinitionValidationUnQuotedMainAttachmentName", "Main attachment name is not quoted string ({0}).", this.mainAttachmentName);
                theError3 = new VWValidationError(6, 1, this.name, null, theMessage7.toString(), null);
                validationContext.addValidationError(theError3);
            }
            String unquotedName = this.mainAttachmentName.substring(firstQuoteIdx + 1, lastQuoteIdx);
            VWFieldDefinition tempField = null;
            IField inheritedField = null;
            int maType = -1;
            try {
                tempField = this.getField(unquotedName);
            }
            catch (Exception e) {
                try {
                    inheritedField = this.getBaseWorkflowSignature(validationContext).getField(unquotedName);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (tempField != null) {
                maType = tempField.getFieldType();
            } else if (inheritedField != null) {
                maType = inheritedField.getFieldType();
            }
            if (maType != 32) {
                theMessage = new VWString("vw.api.VWWorkflowDefinitionValidationBadMainAttachment", "Field named as the main attachment ({0}), either does not exist or it exists but it is not an attachment field.", this.mainAttachmentName);
                theError = new VWValidationError(6, 1, this.name, null, theMessage.toString(), null);
                validationContext.addValidationError(theError);
            }
        }
        if ((fields = this.getFields()) != null) {
            for (int i = 0; i < fields.length; ++i) {
                fields[i].validate(validationContext);
            }
        }
        if ((maps = this.getMaps()) != null) {
            for (int i = 0; i < maps.length; ++i) {
                maps[i].validate(validationContext);
            }
        }
        if ((mls = this.getMilestones()) != null) {
            for (int i = 0; i < mls.length; ++i) {
                mls[i].validate(validationContext);
            }
        }
        if ((ss = this.getSchemas()) != null) {
            for (int i = 0; i < ss.length; ++i) {
                ss[i].validate(validationContext);
            }
        }
        if (this.incomingWSAttachmentFolder != null) {
            VWAttachment testIncomingAttachmentFolder = null;
            try {
                testIncomingAttachmentFolder = new VWAttachment(this.incomingWSAttachmentFolder);
            }
            catch (VWException e) {
                theMessage = new VWString("vw.api.VWWorkflowDefinitionBadIncomingAttachmentFolderSpec", "Incoming attachment folder specification ({0}) is not a correct attachment specification for the following reason : {1}", this.incomingWSAttachmentFolder, e.getMessage());
                theError = new VWValidationError(6, 1, this.name, null, theMessage.toString(), null);
                validationContext.addValidationError(theError);
            }
            if (testIncomingAttachmentFolder != null && testIncomingAttachmentFolder.getType() != 2) {
                VWString theMessage8 = new VWString("vw.api.VWWorkflowDefinitionIncomingAttachmentFolderNotAFolder", "Incoming attachment folder is not a folder, it''s a  ({0}).", VWAttachmentType.typeToString(testIncomingAttachmentFolder.getType()));
                VWValidationError theError7 = new VWValidationError(6, 1, this.name, null, theMessage8.toString(), null);
                validationContext.addValidationError(theError7);
            }
        }
        if ((pls = (flatWF = this.makeFlattenedWF(this.getBaseWorkflowDefinition(validationContext), this)).getPartnerLinks()) != null) {
            for (int i = 0; i < pls.length; ++i) {
                pls[i].validate(validationContext);
            }
        }
        if (this.versionAgnostic && (pls == null || pls.length == 0)) {
            VWString theMessage9 = new VWString("vw.api.VWWorkflowDefinitionVersionAgnosticButNoPO", "The web services version agnostic flag is set to true, but there are no partner links defined in this workflow definition or it''s parent workflow definition.  Setting the version agnostic flag to true may limit future changes to the worflow, the flag should not be set to true in a workflow that does not perform any web service operations.");
            theError = new VWValidationError(6, 1, this.name, null, theMessage9.toString(), null);
            validationContext.addValidationError(theError);
        }
        return validationContext.getValidationErrors();
    }

    public VWFieldDefinition createFieldUsingObject(String theName, Object theValue) throws VWException {
        VWFieldDefinition newDataField = new VWFieldDefinition(this, theName, theValue);
        this.fields = (VWFieldDefinition[])this.fieldsHandler.addElementToArray(this.fields, newDataField);
        return newDataField;
    }

    public VWFieldDefinition createFieldUsingString(String theName, String theValueString, int theType, boolean theIsArray) throws VWException {
        VWFieldDefinition newDataField = new VWFieldDefinition(this, theName, theValueString, theType, theIsArray, true);
        this.fields = (VWFieldDefinition[])this.fieldsHandler.addElementToArray(this.fields, newDataField);
        return newDataField;
    }

    protected VWFieldDefinition createFieldNoValidateName(String theName, String theValueString, int theType, boolean theIsArray) throws VWException {
        if (theIsArray && theType == 2 && theName.equals("F_Trackers")) {
            theType = 64;
        }
        VWFieldDefinition newDataField = new VWFieldDefinition(this, theName, theValueString, theType, theIsArray, false);
        this.fields = (VWFieldDefinition[])this.fieldsHandler.addElementToArray(this.fields, newDataField);
        return newDataField;
    }

    public void deleteField(String theName) throws VWException {
        int index = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", theName);
        if (index == -1) {
            throw new VWException("vw.api.VWWorkflowDefinitionDataFieldNotFound", "No data field found with name equal to {0} in workflow definition.", theName);
        }
        this.fieldsHandler.deleteElementFromArray(this.fields, index);
    }

    public VWMapDefinition createMap(String theName) throws VWException {
        VWMapDefinition newMap = new VWMapDefinition(this, theName, true);
        this.maps = (VWMapDefinition[])this.mapsHandler.addElementToArray(this.maps, newMap);
        return newMap;
    }

    public VWMapDefinition insertMap(VWMapDefinition theMap) throws VWException {
        if (theMap == null) {
            return null;
        }
        VWMapDefinition existingMap = null;
        try {
            existingMap = this.getMap(theMap.getName());
        }
        catch (VWException vWException) {
            // empty catch block
        }
        if (existingMap != null) {
            throw new VWException("vw.api.VWWorkflowDefinitionInsertMapAlreadyExists", "Cannot insert map, a map named {0} already exists.", theMap.getName());
        }
        theMap.setWorkflow(this);
        this.maps = (VWMapDefinition[])this.mapsHandler.addElementToArray(this.maps, theMap);
        return theMap;
    }

    public VWFieldDefinition insertField(VWFieldDefinition theField) throws VWException {
        if (theField == null) {
            return null;
        }
        VWFieldDefinition existingField = null;
        try {
            existingField = this.getField(theField.getName());
        }
        catch (VWException vWException) {
            // empty catch block
        }
        if (existingField != null) {
            throw new VWException("vw.api.VWWorkflowDefinitionInsertFieldAlreadyExists", "Cannot insert field, a field named {0} already exists.", theField.getName());
        }
        theField.setWorkflow(this);
        this.fields = (VWFieldDefinition[])this.fieldsHandler.addElementToArray(this.fields, theField);
        return theField;
    }

    public VWMilestoneDefinition insertMilestone(VWMilestoneDefinition theMilestone) throws VWException {
        if (theMilestone == null) {
            return null;
        }
        VWMilestoneDefinition existingMilestone = null;
        try {
            existingMilestone = this.getMilestone(theMilestone.getName());
        }
        catch (VWException vWException) {
            // empty catch block
        }
        if (existingMilestone != null) {
            throw new VWException("vw.api.VWWorkflowDefinitionInsertMilestoneAlreadyExists", "Cannot insert milestone, a milestone named {0} already exists.", theMilestone.getName());
        }
        theMilestone.setWorkflow(this);
        this.milestones = (VWMilestoneDefinition[])this.milestonesHandler.addElementToArray(this.milestones, theMilestone);
        return theMilestone;
    }

    public VWRuleSetDefinition insertRuleSet(VWRuleSetDefinition theRuleSet) throws VWException {
        if (theRuleSet == null) {
            return null;
        }
        if (this.isExistingRuleSet(theRuleSet.getName())) {
            throw new VWException("vw.api.VWWorkflowDefinitionInsertRuleSetAlreadyExists", "Cannot insert ruleset, a ruleset named {0} already exists.", theRuleSet.getName());
        }
        theRuleSet.setWorkflow(this);
        this.ruleSets = (VWRuleSetDefinition[])this.ruleSetsHandler.addElementToArray(this.ruleSets, theRuleSet);
        return theRuleSet;
    }

    public VWPartnerLinkDefinition insertPartnerLink(VWPartnerLinkDefinition thePartnerLink) throws VWException {
        if (thePartnerLink == null) {
            return null;
        }
        if (this.isExistingPartnerLinkName(thePartnerLink.getName())) {
            throw new VWException("vw.api.VWWorkflowDefinitionInsertPartnerLinkAlreadyExists", "Cannot insert partner link, a partner link named {0} already exists.", thePartnerLink.getName());
        }
        thePartnerLink.setWorkflow(this);
        this.partnerLinks = (VWPartnerLinkDefinition[])this.partnerLinkHandler.addElementToArray(this.partnerLinks, thePartnerLink);
        return thePartnerLink;
    }

    public VWSchema insertSchema(VWSchema theSchema) throws VWException {
        if (theSchema == null) {
            return null;
        }
        if (this.isExistingSchemaName(theSchema.getName())) {
            throw new VWException("vw.api.VWWorkflowDefinitionInsertSchemaNameAlreadyExists", "Cannot insert schema, a schema named {0} already exists.", theSchema.getName());
        }
        theSchema.setWorkflow(this);
        this.schemas = (VWSchema[])this.schemaHandler.addElementToArray(this.schemas, theSchema);
        return theSchema;
    }

    protected VWMapDefinition createEmptyMap(String theName) throws VWException {
        VWMapDefinition newMap = new VWMapDefinition(this, theName, false);
        this.maps = (VWMapDefinition[])this.mapsHandler.addElementToArray(this.maps, newMap);
        return newMap;
    }

    public void deleteMap(int theMapId) throws VWException {
        throw new VWException("vw.api.VWWorkflowDefinitiondeleteByIdMethodDeprecated", "This method has been deprecated, you must use deleteMap(String) instead to delete a map using the map name as the parameter.");
    }

    public void deleteMap(String theMapName) throws VWException {
        this.deleteMap(theMapName, true);
    }

    protected void deleteMap(String theMapName, boolean cleanUpPORefs) throws VWException {
        VWMapNode[] theSteps;
        int index = this.mapsHandler.getIndexFromStringFieldValue(this.maps, "name", theMapName);
        if (index == -1) {
            throw new VWException("vw.api.VWWorkflowDefinitionMapNotFound", "No map found with name equal to {0} in workflow definition.", theMapName);
        }
        if (cleanUpPORefs && (theSteps = this.maps[index].getSteps()) != null) {
            for (int i = 0; i < theSteps.length; ++i) {
                VWInstructionDefinition[] theInsts;
                if (theSteps[i] == null || !(theSteps[i] instanceof VWCompoundStepDefinition) || (theInsts = ((VWCompoundStepDefinition)theSteps[i]).getInstructions()) == null) continue;
                int instCount = theInsts.length;
                for (int k = 0; k < instCount; ++k) {
                    if (theInsts[k].getAction() == 40 && ((VWReceiveInstruction)theInsts[k]).getPartnerLinkName() != null && ((VWReceiveInstruction)theInsts[k]).getPartnerLinkName().length() > 0 && this.isExistingPartnerLinkName(((VWReceiveInstruction)theInsts[k]).getPartnerLinkName())) {
                        this.getPartnerLink(((VWReceiveInstruction)theInsts[k]).getPartnerLinkName()).removeReceiveStepRef((VWReceiveInstruction)theInsts[k]);
                    }
                    if (theInsts[k].getAction() != 41 || ((VWReplyInstruction)theInsts[k]).getPartnerLinkName() == null || ((VWReplyInstruction)theInsts[k]).getPartnerLinkName().length() <= 0 || !this.isExistingPartnerLinkName(((VWReplyInstruction)theInsts[k]).getPartnerLinkName())) continue;
                    this.getPartnerLink(((VWReplyInstruction)theInsts[k]).getPartnerLinkName()).removeReplyStepRef((VWReplyInstruction)theInsts[k]);
                }
            }
        }
        this.mapsHandler.deleteElementFromArray(this.maps, index);
    }

    protected VWWorkflowCollectionDefinition getWorkflowCollection() {
        return this.myWorkflowCollection;
    }

    protected void setWorkflowCollection(VWWorkflowCollectionDefinition theWorkflowCollection) {
        this.myWorkflowCollection = theWorkflowCollection;
    }

    public String getName() {
        return this.translateStr(this.name);
    }

    public void setName(String theName) throws VWException {
        if (theName == null) {
            throw new VWException("vw.api.VWWorkflowDefinitionNullName", "Workflow name cannot be null.");
        }
        if (theName.equals(this.name)) {
            return;
        }
        if (theName.startsWith("~")) {
            throw new VWException("vw.api.VWWorkflowDefinitionNameCantStartWithTilde", "The name {0} is invalid, because workflow names cannot begin with ~, that character is reserved for internal use.", theName);
        }
        if (this.baseWorkClassName != null && theName.compareTo(this.baseWorkClassName) == 0) {
            throw new VWException("vw.api.VWWorkflowDefinitionNameCannotEqualBaseName", "The name of the workflow, \"{0}\" can not be the same as the base workflow name.", theName);
        }
        if (this.myWorkflowCollection != null && this.myWorkflowCollection.isExistingWorkflowName(theName, true)) {
            throw new VWException("vw.api.VWWorkflowDefinitionNameAlreadyInCollection", "The name {0} is invalid, because another workflow in the collection has the same name.", theName);
        }
        this.name = theName;
    }

    public String getBaseWorkClassName() {
        String bName = null;
        bName = this.baseWorkClassName == null ? "WorkObjectEx" : this.baseWorkClassName;
        return this.translateStr(bName);
    }

    public void setBaseWorkClassName(String theBaseWorkClassName) throws VWException {
        if (theBaseWorkClassName != null && this.name.compareTo(theBaseWorkClassName) == 0) {
            throw new VWException("vw.api.VWWorkflowDefinitionBaseNameCannotEqualName", "The base workflow name, \"{0}\" can not be the same as the workflow name.", theBaseWorkClassName);
        }
        this.baseWorkClassName = theBaseWorkClassName;
    }

    public String getRosterName() {
        return this.translateStr(this.rosterName);
    }

    public void setRosterName(String theRosterName) throws VWException {
        this.rosterName = theRosterName;
    }

    public String getEventLogName() {
        return this.translateStr(this.eventLogName);
    }

    public void setEventLogName(String theEventLogName) throws VWException {
        this.eventLogName = theEventLogName;
    }

    public String getAuthorTool() {
        return this.authorTool;
    }

    public void setAuthorTool(String theAuthorTool) throws VWException {
        this.authorTool = theAuthorTool;
    }

    public List<String> getOtherAuthorTools() {
        return this.otherAuthorTools;
    }

    protected void setOtherAuthorTools(String s) {
        if (s != null) {
            String[] ss;
            this.otherAuthorTools.clear();
            for (String s2 : ss = s.split(";")) {
                this.otherAuthorTools.add(s2);
            }
        }
    }

    private String getOtherAuthorToolsAsAString() {
        if (this.otherAuthorTools == null || this.otherAuthorTools.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (String s : this.otherAuthorTools) {
            b.append(s).append(";");
        }
        b.setLength(b.length() - 1);
        return b.toString();
    }

    public void addAdditionalAuthorTool(String authorTool) {
        if (this.otherAuthorTools.contains(authorTool)) {
            return;
        }
        this.otherAuthorTools.add(authorTool);
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String theTag) {
        this.tag = theTag;
    }

    public String getDescription() {
        return this.translateStr(this.description);
    }

    public void setDescription(String theDescription) {
        this.description = theDescription;
    }

    public String getMainAttachmentName() {
        return this.translateStr(this.mainAttachmentName);
    }

    public void setMainAttachmentName(String theName) throws VWException {
        if (theName != null) {
            int firstQuoteIdx = theName.indexOf(34);
            int lastQuoteIdx = theName.lastIndexOf(34);
            if (firstQuoteIdx == -1 || lastQuoteIdx == -1 || firstQuoteIdx == lastQuoteIdx) {
                throw new VWException("vw.api.VWWorkflowDefinitionUnquotedMainAttachmentName", "Field name of main attachment is not a quoted string.");
            }
            String unquotedName = theName.substring(firstQuoteIdx + 1, lastQuoteIdx);
            if (unquotedName != null && unquotedName.length() == 0) {
                throw new VWException("vw.api.VWWorkflowDefinitionEmptyMainAttachmentName", "Field name of main attachment cannot be an empty string.");
            }
        }
        this.mainAttachmentName = theName;
    }

    protected void setMainAttachmentNameNoValidate(String theName) {
        if (theName != null) {
            int firstQuoteIdx = theName.indexOf(34);
            int lastQuoteIdx = theName.lastIndexOf(34);
            if (firstQuoteIdx == -1 || lastQuoteIdx == -1 || firstQuoteIdx == lastQuoteIdx) {
                return;
            }
            String unquotedName = theName.substring(firstQuoteIdx + 1, lastQuoteIdx);
            if (unquotedName != null && unquotedName.length() > 0) {
                this.mainAttachmentName = theName;
            }
        }
    }

    public VWFieldDefinition getField(String theName) throws VWException {
        int index = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", theName);
        if (index == -1) {
            String authName = this.translateToAuthored(theName);
            if (authName != null && authName.compareTo(theName) != 0) {
                index = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", authName);
            }
            if (index == -1) {
                throw new VWException("vw.api.VWWorkflowDefinitionDataFieldNotFound", "No data field found with name equal to {0} in workflow definition.", theName);
            }
        }
        return this.fields[index];
    }

    public VWFieldDefinition[] getFields() throws VWException {
        return (VWFieldDefinition[])this.fieldsHandler.getElements(this.fields);
    }

    public VWMapDefinition getMainMap() throws VWException {
        return this.getMap(MAIN_MAP_NAME);
    }

    public VWStepDefinition getLaunchStep() throws VWException {
        return (VWStepDefinition)this.getMainMap().getStartStep();
    }

    public String getSubject() {
        return this.translateStr(this.subject);
    }

    public void setSubject(String theSubject) {
        this.subject = theSubject;
    }

    public VWMapDefinition getMap(int theMapId) throws VWException {
        throw new VWException("vw.api.VWWorkflowDefinitionMethodDeprecated", "This method has been deprecated, you must use getMap(String) instead to get a map using the map name as the parameter.");
    }

    public VWMapDefinition getMap(String theName) throws VWException {
        return this.maps[this.getMapIndex(theName)];
    }

    public int getMapIndex(String theName) throws VWException {
        int index = this.mapsHandler.getIndexFromStringFieldValue(this.maps, "name", theName);
        if (index == -1) {
            String authName = this.translateToAuthored(theName);
            if (authName != null && authName.compareTo(theName) != 0) {
                index = this.mapsHandler.getIndexFromStringFieldValue(this.maps, "name", authName);
            }
            if (index == -1) {
                throw new VWException("vw.api.VWWorkflowDefinitionMapNotFound", "No map found with name equal to {0} in workflow definition.", theName);
            }
        }
        return index;
    }

    public VWMapDefinition[] getMaps() throws VWException {
        return (VWMapDefinition[])this.mapsHandler.getElements(this.maps);
    }

    public long getDeadline() {
        return this.deadline;
    }

    public void setDeadline(long theDeadline) throws VWException {
        if (theDeadline < 0L) {
            throw new VWException("vw.api.VWWorkFlowDefinitionNegativeDeadline", "Negative deadline value {0} not allowed", String.valueOf(theDeadline));
        }
        this.deadline = theDeadline;
    }

    public long getReminder() {
        return this.reminder;
    }

    public void setReminder(long theReminder) throws VWException {
        if (theReminder < 0L) {
            throw new VWException("vw.api.VWWorkFlowDefinitionNegativeReminder", "Negative reminder value {0} not allowed", String.valueOf(theReminder));
        }
        this.reminder = theReminder;
    }

    public static VWWorkflowDefinition read(InputStream theStream) throws VWException {
        if (theStream == null) {
            throw new VWException("vw.api.VWWorkFlowDefinitionNullInputStream", "InputStream parameter is null");
        }
        VWWorkflowDefinition wf = null;
        try {
            InputStreamReader isr = new InputStreamReader(theStream, "UTF8");
            BufferedReader in = new BufferedReader(isr);
            wf = VWWorkflowDefinition.read(in);
        }
        catch (Exception e1) {
            VWException theException = new VWException("vw.api.VWWorkflowDefinitionXMLReadError_1", " Exception reading XML: {0}", e1.getLocalizedMessage());
            theException.setCause(e1);
            throw theException;
        }
        return wf;
    }

    protected static VWWorkflowDefinition read(BufferedReader in) throws VWException {
        VWWorkflowDefinition wf = null;
        try {
            wf = VWXMLHandler.parseXMLWorkFlow(in, true);
        }
        catch (SAXParseException err) {
            VWString parsingError = new VWString("vw.api.ParsingError", "** Parsing error");
            VWString line = new VWString("vw.api.Line", "line");
            String errString = parsingError + ", " + line + " " + err.getLineNumber() + ", uri " + err.getSystemId() + "\n" + "   " + err.getLocalizedMessage();
            VWException theException = new VWException("vw.api.VWWorkflowDefinitionXMLReadParse", "XML Parsing error {0}.", errString);
            theException.setCause(err);
            throw theException;
        }
        catch (Exception e2) {
            VWException theException = new VWException("vw.api.VWWorkflowDefinitionXMLReadError_2", "XML Reading error {0}.", e2.getLocalizedMessage());
            theException.setCause(e2);
            throw theException;
        }
        return wf;
    }

    public static VWWorkflowDefinition readFromFile(String theFileName) throws VWException {
        FileInputStream istream = null;
        try {
            istream = new FileInputStream(theFileName);
            VWWorkflowDefinition vWWorkflowDefinition = VWWorkflowDefinition.read(istream);
            return vWWorkflowDefinition;
        }
        catch (Exception e) {
            if (istream != null) {
                try {
                    ((InputStream)istream).close();
                }
                catch (Exception E) {
                    // empty catch block
                }
            }
            VWException theException = new VWException("vw.api.VWWorkflowDefinitionXMLReadFromFileError", " Exception reading XML file: {0}.", e.getLocalizedMessage());
            theException.setCause(e);
            throw theException;
        }
        finally {
            if (istream != null) {
                try {
                    ((InputStream)istream).close();
                }
                catch (Exception E) {}
            }
        }
    }

    public void write(OutputStream theStream) throws VWException {
        if (theStream == null) {
            throw new VWException("vw.api.VWWorkFlowDefinitionNullStream", "output stream parameter is null");
        }
        StringBuffer workflowXML = new StringBuffer();
        this.toXML(workflowXML);
        try {
            OutputStreamWriter out = new OutputStreamWriter(theStream, "UTF8");
            out.write(workflowXML.toString());
            ((Writer)out).flush();
        }
        catch (Exception e) {
            throw new VWException("vw.api.VWWorkflowDefinitionXMLWriteError", " Exception writing XML: {0}.", e.getLocalizedMessage());
        }
    }

    public void writeToFile(String theFileName) throws VWException {
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(theFileName);
            this.write(ostream);
        }
        catch (Exception e) {
            throw new VWException("vw.api.VWWorkflowDefinitionXMLWriteToFileError", " Exception writing XML to file: {0}.", e.getLocalizedMessage());
        }
        finally {
            if (ostream != null) {
                try {
                    ((OutputStream)ostream).close();
                }
                catch (Exception E) {}
            }
        }
    }

    public String toString() {
        return this.getSubject();
    }

    public String AsXMLString() throws VWException {
        StringBuffer workflowXML = new StringBuffer();
        this.toXML(workflowXML);
        return workflowXML.toString();
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.internal_toXML(theBuffer, true);
    }

    protected void toXML_withNoXMLDeclaration(StringBuffer theBuffer) throws VWException {
        this.internal_toXML(theBuffer, false);
    }

    protected void internal_toXML(StringBuffer theBuffer, boolean includeXMLDeclaration) throws VWException {
        VWMapDefinition[] m;
        VWRuleSetDefinition[] rl;
        VWSchema[] ss;
        VWPartnerLinkDefinition[] pl;
        VWMilestoneDefinition[] ml;
        VWFieldDefinition[] f;
        String ATTRIB_INDENT = "\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWWorkflowDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        if (includeXMLDeclaration) {
            theBuffer.append("<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE WorkFlowDefinition SYSTEM \"wfdef4.dtd\">\n<WorkFlowDefinition ApiVersion=\"4.0\"\nOrigin=\"JavaAPI\"\n");
        } else {
            theBuffer.append("<WorkFlowDefinition ApiVersion=\"4.0\"\nOrigin=\"JavaAPI\"\n");
        }
        if (this.subject != null) {
            theBuffer.append(ATTRIB_INDENT + "Subject=\"" + VWXMLHandler.toXMLString(this.getSubject()) + "\"");
        }
        if (this.description != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Description=\"" + VWXMLHandler.toXMLString(this.getDescription()) + "\"");
        }
        if (this.name != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Name=\"" + VWXMLHandler.toXMLString(this.getName()) + "\"");
        }
        if (this.deadline > 0L) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Deadline=\"" + Long.toString(this.deadline) + "\"");
        }
        if (this.reminder > 0L) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Reminder=\"" + Long.toString(this.reminder) + "\"");
        }
        theBuffer.append("\n" + ATTRIB_INDENT + "DisableEmailNotification=\"" + VWXMLHandler.booleanToString(this.disableEmailNotification) + "\"");
        if (this.mainAttachmentName != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "MainAttachment=\"" + VWXMLHandler.toXMLString(this.getMainAttachmentName()) + "\"");
        }
        if (this.baseWorkClassName != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "BaseWorkClass=\"" + VWXMLHandler.toXMLString(this.getBaseWorkClassName()) + "\"");
        }
        if (this.rosterName != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Roster=\"" + VWXMLHandler.toXMLString(this.getRosterName()) + "\"");
        }
        if (this.eventLogName != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "EventLog=\"" + VWXMLHandler.toXMLString(this.getEventLogName()) + "\"");
        }
        if (this.tag != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Tag=\"" + VWXMLHandler.toXMLString(this.getTag()) + "\"");
        }
        if (this.incomingWSAttachmentFolder != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "IncomingWSAttachmentFolder=\"" + VWXMLHandler.toXMLString(this.incomingWSAttachmentFolder) + "\"");
        }
        if (this.authorTool != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "AuthorTool=\"" + VWXMLHandler.toXMLString(this.getAuthorTool()) + "\"");
        }
        if (this.otherAuthorTools != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "OtherAuthorTools=\"" + VWXMLHandler.toXMLString(this.getOtherAuthorToolsAsAString()) + "\"");
        }
        theBuffer.append("\n" + ATTRIB_INDENT + "versionAgnostic=\"" + this.versionAgnostic + "\"");
        theBuffer.append("\n" + ATTRIB_INDENT + "validateUsingSchema=\"" + this.validateUsingSchema + "\"");
        theBuffer.append("\n" + ATTRIB_INDENT + "validateFlag=\"" + this.validateFlag + "\"");
        theBuffer.append("\n" + ATTRIB_INDENT + "transferFlag=\"" + this.transferFlag + "\"");
        theBuffer.append(">\n");
        if (this.runtimeId != null) {
            this.runtimeId.toXML(theBuffer);
        }
        if ((f = this.getFields()) != null) {
            for (int i = 0; i < f.length; ++i) {
                f[i].toXML(theBuffer);
            }
        }
        if ((ml = this.getMilestones()) != null) {
            for (int i = 0; i < ml.length; ++i) {
                ml[i].toXML(theBuffer);
            }
        }
        if ((pl = this.getPartnerLinks()) != null) {
            theBuffer.append(ATTRIB_INDENT + "<partnerLinks>\n");
            for (int i = 0; i < pl.length; ++i) {
                pl[i].toXML(theBuffer);
            }
            theBuffer.append(ATTRIB_INDENT + "</partnerLinks>\n");
        }
        if ((ss = this.getSchemas()) != null) {
            theBuffer.append(ATTRIB_INDENT + "<types>\n");
            for (int i = 0; i < ss.length; ++i) {
                ss[i].toXML(theBuffer);
            }
            theBuffer.append(ATTRIB_INDENT + "</types>\n");
        }
        if ((rl = this.getRuleSets()) != null) {
            for (int i = 0; i < rl.length; ++i) {
                rl[i].toXML(theBuffer);
            }
        }
        if ((m = this.getMaps()) != null) {
            for (int i = 0; i < m.length; ++i) {
                m[i].toXML(theBuffer);
            }
        }
        if (this.attributes != null) {
            this.attributes.toXML(theBuffer, ATTRIB_INDENT);
        }
        theBuffer.append("</WorkFlowDefinition>\n");
    }

    public void toXPDL(String indentA, StringBuffer theBuffer) throws VWException {
        VWPartnerLinkDefinition[] pl;
        int i;
        VWMapDefinition[] maps;
        VWRuleSetDefinition[] rl;
        VWSchema[] ss;
        VWMilestoneDefinition[] ml;
        String indentB = VWXMLHandler.incXMLIndent(indentA);
        String indentC = VWXMLHandler.incXMLIndent(indentB);
        String indentD = VWXMLHandler.incXMLIndent(indentC);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWWorkflowDefinitionXPDLNullBuffer", "toXPDL buffer parameter cannot be null.");
        }
        if (this.getWorkflowCollection() == null) {
            throw new VWException("vw.api.VWWorkflowDefinitionNullWorkflowCollection", "Cannot call toXPDL() on this workflow definition because it has no reference to a containing workflow collection definition.");
        }
        theBuffer.append(indentA + "<WorkflowProcess Id=\"" + this.getWorkflowCollection().getWorkflowIndex(this.getName()) + "\" Name=\"" + VWXMLHandler.toXMLString(this.getName()) + "\">\n");
        theBuffer.append(indentB + "<ProcessHeader>\n");
        if (this.description != null) {
            theBuffer.append(indentC + "<Description>" + VWXMLHandler.toXMLString(this.getDescription()) + "</Description>\n");
        }
        theBuffer.append(indentC + "<fn:WorkflowDefinition ApiVersion=\"" + "4.0" + "\" Origin=\"JavaAPI\"");
        if (this.subject != null) {
            theBuffer.append("\n" + indentD + "Subject=\"" + VWXMLHandler.toXMLString(this.getSubject()) + "\"");
        }
        if (this.deadline > 0L) {
            theBuffer.append("\n" + indentD + "Deadline=\"" + Long.toString(this.deadline) + "\"");
        }
        if (this.reminder > 0L) {
            theBuffer.append("\n" + indentD + "Reminder=\"" + Long.toString(this.reminder) + "\"");
        }
        theBuffer.append("\n" + indentD + "DisableEmailNotification=\"" + VWXMLHandler.booleanToString(this.disableEmailNotification) + "\"");
        if (this.mainAttachmentName != null) {
            theBuffer.append("\n" + indentD + "MainAttachment=\"" + VWXMLHandler.toXMLString(this.getMainAttachmentName()) + "\"");
        }
        if (this.baseWorkClassName != null) {
            theBuffer.append("\n" + indentD + "BaseWorkClass=\"" + VWXMLHandler.toXMLString(this.getBaseWorkClassName()) + "\"");
        }
        if (this.rosterName != null) {
            theBuffer.append("\n" + indentD + "Roster=\"" + VWXMLHandler.toXMLString(this.getRosterName()) + "\"");
        }
        if (this.eventLogName != null) {
            theBuffer.append("\n" + indentD + "EventLog=\"" + VWXMLHandler.toXMLString(this.getEventLogName()) + "\"");
        }
        if (this.tag != null) {
            theBuffer.append("\n" + indentD + "Tag=\"" + VWXMLHandler.toXMLString(this.getTag()) + "\"");
        }
        if (this.incomingWSAttachmentFolder != null) {
            theBuffer.append("\n" + indentD + "IncomingWSAttachmentFolder=\"" + VWXMLHandler.toXMLString(this.incomingWSAttachmentFolder) + "\"");
        }
        if (this.authorTool != null) {
            theBuffer.append("\n" + indentD + "AuthorTool=\"" + VWXMLHandler.toXMLString(this.getAuthorTool()) + "\"");
        }
        if (this.authorTool != null) {
            theBuffer.append("\n" + indentD + "OtherAuthorTools=\"" + VWXMLHandler.toXMLString(this.getOtherAuthorToolsAsAString()) + "\"");
        }
        theBuffer.append("\n" + indentD + "versionAgnostic=\"" + this.versionAgnostic + "\"");
        theBuffer.append("\n" + indentD + "validateUsingSchema=\"" + this.validateUsingSchema + "\"");
        theBuffer.append("\n" + indentD + "validateFlag=\"" + this.validateFlag + "\"");
        theBuffer.append("\n" + indentD + "transferFlag=\"" + this.transferFlag + "\"");
        VWMapDefinition mainMap = null;
        try {
            mainMap = this.getMainMap();
        }
        catch (VWException ex) {
            // empty catch block
        }
        if (mainMap != null) {
            theBuffer.append("\n" + indentD + "ActivitySetId=\"Process" + this.getWorkflowCollection().getWorkflowIndex(this.getName()) + ".Map" + this.getMapIndex(mainMap.getName()) + "\"");
        }
        theBuffer.append(">\n");
        if (this.runtimeId != null) {
            this.runtimeId.toXML(theBuffer);
        }
        if ((ml = this.getMilestones()) != null) {
            for (int i2 = 0; i2 < ml.length; ++i2) {
                ml[i2].toXPDL(indentD, theBuffer);
            }
        }
        if ((ss = this.getSchemas()) != null) {
            theBuffer.append(indentD + "<types>\n");
            for (int i3 = 0; i3 < ss.length; ++i3) {
                ss[i3].toXML(theBuffer);
            }
            theBuffer.append(indentD + "</types>\n");
        }
        if ((rl = this.getRuleSets()) != null) {
            for (int i4 = 0; i4 < rl.length; ++i4) {
                rl[i4].toXML(theBuffer, indentD);
            }
        }
        if (this.attributes != null) {
            this.attributes.toXML(theBuffer, indentD);
        }
        theBuffer.append(indentC + "</fn:WorkflowDefinition>\n");
        theBuffer.append(indentB + "</ProcessHeader>\n");
        VWFieldDefinition[] f = this.getFields();
        if (f != null) {
            theBuffer.append(indentB + "<DataFields>\n");
            for (int i5 = 0; i5 < f.length; ++i5) {
                f[i5].toXPDL(indentC, theBuffer);
            }
            theBuffer.append(indentB + "</DataFields>\n");
        }
        if ((maps = this.getMaps()) != null) {
            int nSubMapCount = maps.length;
            if (mainMap != null) {
                --nSubMapCount;
            }
            if (nSubMapCount > 0) {
                theBuffer.append(indentB + "<ActivitySets>\n");
                for (i = 0; i < maps.length; ++i) {
                    if (maps[i] == mainMap) continue;
                    theBuffer.append(indentC + "<ActivitySet Id=\"" + "Process" + this.getWorkflowCollection().getWorkflowIndex(this.getName()) + ".Map" + this.getMapIndex(maps[i].getName()) + "\" Name=\"" + VWXMLHandler.toXMLString(maps[i].getName()) + "\"\n");
                    if (maps[i].description != null) {
                        theBuffer.append(indentD + "fn:Description=\"" + VWXMLHandler.toXMLString(maps[i].description) + "\"\n");
                    }
                    theBuffer.append(indentD + "fn:MaxStepId=\"" + Integer.toString(maps[i].stepIdGenerator.getPrevId()) + "\">\n");
                    maps[i].toXPDL(indentD, theBuffer);
                    theBuffer.append(indentC + "</ActivitySet>\n");
                }
                theBuffer.append(indentB + "</ActivitySets>\n");
            }
            if (mainMap != null) {
                mainMap.toXPDL(indentB, theBuffer);
                theBuffer.append(indentB + "<ExtendedAttributes>\n");
                theBuffer.append(indentC + "<ExtendedAttribute Name=\"fn:WorkflowName\" Value=\"" + VWXMLHandler.toXMLString(mainMap.getName()) + "\"/>\n");
                theBuffer.append(indentC + "<ExtendedAttribute Name=\"fn:MaxStepId\" Value=\"" + Integer.toString(mainMap.stepIdGenerator.getPrevId()) + "\"/>\n");
                if (mainMap.description != null) {
                    theBuffer.append(indentC + "<ExtendedAttribute Name=\"fn:Description\" Value=\"" + VWXMLHandler.toXMLString(mainMap.description) + "\"/>\n");
                }
                theBuffer.append(indentB + "</ExtendedAttributes>\n");
            }
        }
        if ((pl = this.getPartnerLinks()) != null && pl.length > 0) {
            theBuffer.append(indentB + "<PartnerLinks>\n");
            for (i = 0; i < pl.length; ++i) {
                pl[i].toXPDL(indentC, theBuffer);
            }
            theBuffer.append(indentB + "</PartnerLinks>\n");
        }
        theBuffer.append(indentA + "</WorkflowProcess>\n");
    }

    protected boolean isExistingFieldName(String theName) throws VWException {
        int index = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", theName);
        return index != -1;
    }

    protected boolean isExistingMapName(String theName) throws VWException {
        int index = this.mapsHandler.getIndexFromStringFieldValue(this.maps, "name", theName);
        return index != -1;
    }

    protected boolean isExistingMilestoneName(String theName) throws VWException {
        int index = this.milestonesHandler.getIndexFromStringFieldValue(this.milestones, "name", theName);
        return index != -1;
    }

    protected boolean isExistingPartnerLinkName(String theName) throws VWException {
        int index = this.partnerLinkHandler.getIndexFromStringFieldValue(this.partnerLinks, "m_Name", theName);
        return index != -1;
    }

    protected boolean isExistingSchemaName(String theName) throws VWException {
        int index = this.schemaHandler.getIndexFromStringFieldValue(this.schemas, "m_Name", theName);
        return index != -1;
    }

    public VWMilestoneDefinition getMilestone(String theName) throws VWException {
        int index = this.milestonesHandler.getIndexFromStringFieldValue(this.milestones, "name", theName);
        if (index == -1) {
            String authName = this.translateToAuthored(theName);
            if (authName != null && authName.compareTo(theName) != 0) {
                index = this.milestonesHandler.getIndexFromStringFieldValue(this.milestones, "name", authName);
            }
            if (index == -1) {
                throw new VWException("vw.api.VWWorkflowDefinitionMileStoneNotFound", "No milestone found with name equal to {0} in workflow definition.", theName);
            }
        }
        return this.milestones[index];
    }

    public VWMilestoneDefinition[] getMilestones() throws VWException {
        return (VWMilestoneDefinition[])this.milestonesHandler.getElements(this.milestones);
    }

    public void setMilestones(VWMilestoneDefinition[] theMilestones) throws VWException {
        if (theMilestones == null) {
            throw new VWException("vw.api.VWWorkflowDefinitionNullMilestoneArray", "The milestone array cannot be null.");
        }
        if (theMilestones.length != this.milestonesHandler.getElementCount()) {
            throw new VWException("vw.api.VWWorkflowDefinitionMilestoneArrayWrongLength", "The milestone array length is {0}, but it should equal the number of milestones in this workflow ({1}).", String.valueOf(theMilestones.length), String.valueOf(this.milestonesHandler.getElementCount()));
        }
        for (int i = 0; i < theMilestones.length; ++i) {
            if (theMilestones[i] != null) continue;
            throw new VWException("vw.api.VWWorkflowDefinitionMilestoneArrayNullElement", "theMilestones[{0}] is null.", String.valueOf(i));
        }
        this.milestones = theMilestones;
    }

    public VWMilestoneDefinition createMilestone(String theName) throws VWException {
        VWMilestoneDefinition newMilestone = new VWMilestoneDefinition(this, theName);
        this.milestones = (VWMilestoneDefinition[])this.milestonesHandler.addElementToArray(this.milestones, newMilestone);
        return newMilestone;
    }

    public void deleteMilestone(String theName) throws VWException {
        int index = this.milestonesHandler.getIndexFromStringFieldValue(this.milestones, "name", theName);
        if (index == -1) {
            throw new VWException("vw.api.VWWorkflowDefinitionMilestoneNotFound", "No milestone found named {0} in workflow definition.", theName);
        }
        this.milestonesHandler.deleteElementFromArray(this.milestones, index);
    }

    public VWPartnerLinkDefinition createPartnerLink(String theName) throws VWException {
        VWPartnerLinkDefinition newPartnerLink = new VWPartnerLinkDefinition(this, theName);
        this.partnerLinks = (VWPartnerLinkDefinition[])this.partnerLinkHandler.addElementToArray(this.partnerLinks, newPartnerLink);
        this.syncPartnerLinkReferences();
        return newPartnerLink;
    }

    public void deletePartnerLink(String theName) throws VWException {
        int index = this.partnerLinkHandler.getIndexFromStringFieldValue(this.partnerLinks, "m_Name", theName);
        if (index == -1) {
            throw new VWException("vw.api.VWWorkflowDefinitionPartnerLinkNotFound", "No partner link found named {0} in workflow definition.", theName);
        }
        this.partnerLinkHandler.deleteElementFromArray(this.partnerLinks, index);
        this.syncPartnerLinkReferences();
    }

    public VWPartnerLinkDefinition getPartnerLink(String theName) throws VWException {
        int index = this.partnerLinkHandler.getIndexFromStringFieldValue(this.partnerLinks, "m_Name", theName);
        if (index == -1) {
            String authName = this.translateToAuthored(theName);
            if (authName != null && authName.compareTo(theName) != 0) {
                index = this.partnerLinkHandler.getIndexFromStringFieldValue(this.partnerLinks, "m_Name", authName);
            }
            if (index == -1) {
                throw new VWException("vw.api.VWWorkflowDefinitionPartnerLinkNotFound", "No partner link found with name equal to {0} in workflow definition.", theName);
            }
        }
        return this.partnerLinks[index];
    }

    public VWSchema createSchema(String theName) throws VWException {
        VWSchema newSchema = new VWSchema(this, theName);
        this.schemas = (VWSchema[])this.schemaHandler.addElementToArray(this.schemas, newSchema);
        return newSchema;
    }

    public void deleteSchema(String theName) throws VWException {
        int index = this.schemaHandler.getIndexFromStringFieldValue(this.schemas, "m_Name", theName);
        if (index == -1) {
            throw new VWException("vw.api.VWWorkflowDefinitionSchemaNotFound", "No schema found named {0} in workflow definition.", theName);
        }
        this.schemaHandler.deleteElementFromArray(this.schemas, index);
    }

    public VWSchema getSchema(String theName) throws VWException {
        int index = this.schemaHandler.getIndexFromStringFieldValue(this.schemas, "m_Name", theName);
        if (index == -1) {
            String authName = this.translateToAuthored(theName);
            if (authName != null && authName.compareTo(theName) != 0) {
                index = this.schemaHandler.getIndexFromStringFieldValue(this.schemas, "m_Name", authName);
            }
            if (index == -1) {
                throw new VWException("vw.api.VWWorkflowDefinitionSchemaNotFound", "No schema found with name equal to {0} in workflow definition.", theName);
            }
        }
        return this.schemas[index];
    }

    public VWPartnerLinkDefinition[] getPartnerLinks() throws VWException {
        return (VWPartnerLinkDefinition[])this.partnerLinkHandler.getElements(this.partnerLinks);
    }

    public VWSchema[] getSchemas() throws VWException {
        return (VWSchema[])this.schemaHandler.getElements(this.schemas);
    }

    public void setPartnerLinks(VWPartnerLinkDefinition[] ThePartnerLinks) throws VWException {
        if (ThePartnerLinks == null) {
            throw new VWException("vw.api.VWWorkflowDefinitionNullPartnerLinkArray", "The new partner link array cannot be null.");
        }
        if (ThePartnerLinks.length != this.partnerLinkHandler.getElementCount()) {
            throw new VWException("vw.api.VWWorkflowDefinitionPartnerLinkArrayWrongLength", "The partner link array length is {0}, but it should equal the number of partner links in this workflow ({1}).", String.valueOf(ThePartnerLinks.length), String.valueOf(this.partnerLinkHandler.getElementCount()));
        }
        for (int i = 0; i < ThePartnerLinks.length; ++i) {
            if (ThePartnerLinks[i] != null) continue;
            throw new VWException("vw.api.VWWorkflowDefinitionPartnerLinkArrayNullElement", "ThePartnerLinks[{0}] is null.", String.valueOf(i));
        }
        this.partnerLinks = ThePartnerLinks;
    }

    public void setSchemas(VWSchema[] TheSchemas) throws VWException {
        if (TheSchemas == null) {
            throw new VWException("vw.api.VWWorkflowDefinitionNullSchemaArray", "The new schema array cannot be null.");
        }
        if (TheSchemas.length != this.schemaHandler.getElementCount()) {
            throw new VWException("vw.api.VWWorkflowDefinitionSchemaArrayWrongLength", "The schema array length is {0}, but it should equal the number of schemas in this workflow ({1}).", String.valueOf(TheSchemas.length), String.valueOf(this.schemaHandler.getElementCount()));
        }
        for (int i = 0; i < TheSchemas.length; ++i) {
            if (TheSchemas[i] != null) continue;
            throw new VWException("vw.api.VWWorkflowDefinitionSchemaArrayNullElement", "TheSchemas[{0}] is null.", String.valueOf(i));
        }
        this.schemas = TheSchemas;
    }

    protected VWWorkflowSignature getBaseWorkflowSignature(VWValidationContext validationContext) throws VWException {
        String baseWorkClassName;
        VWWorkflowSignature baseWorkflowSignature;
        block13: {
            baseWorkflowSignature = null;
            baseWorkClassName = this.getBaseWorkClassName();
            if (validationContext != null) {
                baseWorkflowSignature = validationContext.getWorkflowSignature(baseWorkClassName);
            }
            if (baseWorkflowSignature != null) {
                return baseWorkflowSignature;
            }
            if (this.myWorkflowCollection != null && this.myWorkflowCollection.isExistingWorkflowName(baseWorkClassName, true) && this.myWorkflowCollection.getWorkflow(baseWorkClassName, true).getTransferFlag()) {
                VWWorkflowDefinition parentWF = this.getBaseWorkflowDefinition(validationContext);
                if (parentWF != null) {
                    baseWorkflowSignature = parentWF.getWorkflowSignature(validationContext);
                }
            } else {
                try {
                    if (validationContext != null && validationContext.getVWSession() != null) {
                        baseWorkflowSignature = validationContext.getVWSession().fetchWorkflowSignature(baseWorkClassName);
                    } else {
                        VWWorkflowDefinition parentWF = this.getBaseWorkflowDefinition(validationContext);
                        if (parentWF != null) {
                            baseWorkflowSignature = parentWF.getWorkflowSignature(validationContext);
                        }
                    }
                    if (this.myWorkflowCollection != null && this.myWorkflowCollection.isExistingWorkflowName(baseWorkClassName, true) && !this.myWorkflowCollection.getWorkflow(baseWorkClassName, true).getTransferFlag()) {
                        VWString theMessage = new VWString("vw.api.VWValidationContextInheritsFromWorkFlowInThisCollectionNotTferFlag", "The base workclass, \"{0}\", exists in the workflow collection, but does not have the transfer flag set.  Validation and transfer will use the version found on the server, not the version in the workflow collection.", baseWorkClassName);
                        VWValidationError theError = new VWValidationError(6, 2, null, null, theMessage.toString(), null);
                        if (validationContext != null) {
                            validationContext.addValidationError(theError);
                        }
                    }
                }
                catch (Exception e) {
                    VWString theMessage = new VWString("vw.api.VWValidationContextFailedToGetBaseWorkflowSignature", "The base workclass, \"{0}\", was not found on the server, it may need to be transferred or the region may not have been initialized.", baseWorkClassName);
                    VWValidationError theError = new VWValidationError(6, 1, null, null, theMessage.toString(), null);
                    if (validationContext == null) break block13;
                    validationContext.addValidationError(theError);
                }
            }
        }
        if (validationContext != null) {
            validationContext.putWorkflowSignature(baseWorkClassName, baseWorkflowSignature);
        }
        return baseWorkflowSignature;
    }

    protected VWWorkflowDefinition getBaseWorkflowDefinition(VWValidationContext validationContext) throws VWException {
        String baseWorkClassName;
        VWWorkflowDefinition baseWorkflowDefinition;
        block17: {
            baseWorkflowDefinition = null;
            baseWorkClassName = this.getBaseWorkClassName();
            if (validationContext != null) {
                baseWorkflowDefinition = validationContext.getWorkflowDefinition(baseWorkClassName);
            }
            if (baseWorkflowDefinition != null) {
                return baseWorkflowDefinition;
            }
            if (this.myWorkflowCollection != null && this.myWorkflowCollection.isExistingWorkflowName(baseWorkClassName, true) && this.myWorkflowCollection.getWorkflow(baseWorkClassName, true).getTransferFlag()) {
                baseWorkflowDefinition = this.myWorkflowCollection.getWorkflow(baseWorkClassName, true);
                if (validationContext != null) {
                    baseWorkflowDefinition = baseWorkflowDefinition.getFlattenedCopy(validationContext.getVWSession());
                    baseWorkflowDefinition.addSystemFields();
                }
            } else {
                try {
                    if (validationContext != null && validationContext.getVWSession() != null) {
                        baseWorkflowDefinition = validationContext.getVWSession().fetchWorkflowDefinition(-1, baseWorkClassName, true);
                    } else {
                        baseWorkflowDefinition = new VWWorkflowDefinition();
                        baseWorkflowDefinition.setName(baseWorkClassName);
                        baseWorkflowDefinition.addSystemFields();
                        if (baseWorkClassName.compareTo("CaseWorkObject") == 0) {
                            int nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_Trackers");
                            if (nIndex == -1) {
                                this.createFieldNoValidateName("F_Trackers", "{\"\"}", 64, true);
                            }
                            if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_CaseTask")) == -1) {
                                this.createFieldNoValidateName("F_CaseTask", "", 512, false);
                            }
                            if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_CaseFolder")) == -1) {
                                this.createFieldNoValidateName("F_CaseFolder", "", 512, false);
                            }
                        }
                        if (validationContext != null) {
                            baseWorkflowDefinition = baseWorkflowDefinition.getFlattenedCopy(validationContext.getVWSession());
                        }
                    }
                    if (this.myWorkflowCollection != null && this.myWorkflowCollection.isExistingWorkflowName(baseWorkClassName, true) && !this.myWorkflowCollection.getWorkflow(baseWorkClassName, true).getTransferFlag()) {
                        VWString theMessage = new VWString("vw.api.VWValidationContextInheritsFromWorkFlowInThisCollectionNotTferFlag", "The base workclass, \"{0}\", exists in the workflow collection, but does not have the transfer flag set.  Validation and transfer will use the version found on the server, not the version in the workflow collection.", baseWorkClassName);
                        VWValidationError theError = new VWValidationError(6, 2, null, null, theMessage.toString(), null);
                        if (validationContext != null) {
                            validationContext.addValidationError(theError);
                        }
                    }
                }
                catch (Exception e) {
                    VWString theMessage = new VWString("vw.api.VWValidationContextFailedToGetBaseWorkflowDefinition", "The base workclass, \"{0}\", was not found on the server, it may need to be transferred or the region may not have been initialized.", baseWorkClassName);
                    VWValidationError theError = new VWValidationError(6, 1, null, null, theMessage.toString(), null);
                    if (validationContext == null) break block17;
                    validationContext.addValidationError(theError);
                }
            }
        }
        if (validationContext != null) {
            validationContext.putWorkflowDefinition(baseWorkClassName, baseWorkflowDefinition);
        }
        return baseWorkflowDefinition;
    }

    private void addSystemFields() throws VWException {
        int nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_BindPending");
        if (nIndex == -1) {
            this.createFieldNoValidateName("F_BindPending", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_BoundMachine")) == -1) {
            this.createFieldNoValidateName("F_BoundMachine", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_BoundUser")) == -1) {
            this.createFieldNoValidateName("F_BoundUser", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_Class")) == -1) {
            this.createFieldNoValidateName("F_Class", "", 2, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_Comment")) == -1) {
            this.createFieldNoValidateName("F_Comment", "\"\"", 2, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_CreateTime")) == -1) {
            this.createFieldNoValidateName("F_CreateTime", "", 16, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_Deadline")) == -1) {
            this.createFieldNoValidateName("F_Deadline", "", 16, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_EnqueueTime")) == -1) {
            this.createFieldNoValidateName("F_EnqueueTime", "", 16, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_InstrSheetId")) == -1) {
            this.createFieldNoValidateName("F_InstrSheetId", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_InstrSheetName")) == -1) {
            this.createFieldNoValidateName("F_InstrSheetName", "", 2, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_LastErrorNumber")) == -1) {
            this.createFieldNoValidateName("F_LastErrorNumber", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_LastErrorText")) == -1) {
            this.createFieldNoValidateName("F_LastErrorText", "", 2, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_Locked")) == -1) {
            this.createFieldNoValidateName("F_Locked", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_LockMachine")) == -1) {
            this.createFieldNoValidateName("F_LockMachine", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_LockTime")) == -1) {
            this.createFieldNoValidateName("F_LockTime", "", 16, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_LockUser")) == -1) {
            this.createFieldNoValidateName("F_LockUser", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_MaxMilestone")) == -1) {
            this.createFieldNoValidateName("F_MaxMilestone", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_MinMilestone")) == -1) {
            this.createFieldNoValidateName("F_MinMilestone", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_Occurrence")) == -1) {
            this.createFieldNoValidateName("F_Occurrence", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_Operation")) == -1) {
            this.createFieldNoValidateName("F_Operation", "", 2, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_OperationId")) == -1) {
            this.createFieldNoValidateName("F_OperationId", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_Originator")) == -1) {
            this.createFieldNoValidateName("F_Originator", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_Overdue")) == -1) {
            this.createFieldNoValidateName("F_Overdue", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_ParentWobNum")) == -1) {
            this.createFieldNoValidateName("F_ParentWobNum", "", 2, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_QueueWPClassId")) == -1) {
            this.createFieldNoValidateName("F_QueueWPClassId", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_Reminder")) == -1) {
            this.createFieldNoValidateName("F_Reminder", "", 16, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_Response")) == -1) {
            this.createFieldNoValidateName("F_Response", "", 2, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_ResponseCount")) == -1) {
            this.createFieldNoValidateName("F_ResponseCount", "0", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_Responses")) == -1) {
            this.createFieldNoValidateName("F_Responses", "{0}", 1, true);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_SourceDoc")) == -1) {
            this.createFieldNoValidateName("F_SourceDoc", "\"\"", 2, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_SplitLeg")) == -1) {
            this.createFieldNoValidateName("F_SplitLeg", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_StartTime")) == -1) {
            this.createFieldNoValidateName("F_StartTime", "", 16, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_StepDescription")) == -1) {
            this.createFieldNoValidateName("F_StepDescription", "", 2, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_StepName")) == -1) {
            this.createFieldNoValidateName("F_StepName", "", 2, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_StepProcId")) == -1) {
            this.createFieldNoValidateName("F_StepProcId", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_Subject")) == -1) {
            this.createFieldNoValidateName("F_Subject", "\"\"", 2, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_Tag")) == -1) {
            this.createFieldNoValidateName("F_Tag", "", 2, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_TimeOut")) == -1) {
            this.createFieldNoValidateName("F_TimeOut", "", 16, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_Trackers")) == -1) {
            this.createFieldNoValidateName("F_Trackers", "{\"\"}", 64, true);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_TrackerStatus")) == -1) {
            this.createFieldNoValidateName("F_TrackerStatus", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_TransferUser")) == -1) {
            this.createFieldNoValidateName("F_TransferUser", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_UniqueId")) == -1) {
            this.createFieldNoValidateName("F_UniqueId", "", 8, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_WFDeadline")) == -1) {
            this.createFieldNoValidateName("F_WFDeadline", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_WFReminder")) == -1) {
            this.createFieldNoValidateName("F_WFReminder", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_WobNum")) == -1) {
            this.createFieldNoValidateName("F_WobNum", "", 2, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_WorkClassId")) == -1) {
            this.createFieldNoValidateName("F_WorkClassId", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_WorkClassRevision")) == -1) {
            this.createFieldNoValidateName("F_WorkClassRevision", "0", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_WorkFlowNumber")) == -1) {
            this.createFieldNoValidateName("F_WorkFlowNumber", "", 2, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_WorkOrderId")) == -1) {
            this.createFieldNoValidateName("F_WorkOrderId", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_WorkSpaceId")) == -1) {
            this.createFieldNoValidateName("F_WorkSpaceId", "", 1, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_WsCorrelation")) == -1) {
            this.createFieldNoValidateName("F_WsCorrelation", "", 2, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_WsOperation")) == -1) {
            this.createFieldNoValidateName("F_WsOperation", "", 2, false);
        }
        if ((nIndex = this.fieldsHandler.getIndexFromStringFieldValue(this.fields, "name", "F_WsPortType")) == -1) {
            this.createFieldNoValidateName("F_WsPortType", "", 2, false);
        }
    }

    protected VWWorkflowSignature getWorkflowSignature(VWValidationContext validationContext) throws VWException {
        int numMaps = this.mapsHandler.getElementCount();
        String[] mapNames = new String[numMaps];
        for (int i = 0; i < numMaps; ++i) {
            mapNames[i] = this.maps[i].getName();
        }
        int tagType = -1;
        if (this.tag != null && this.tag.length() > 0) {
            VWCompiledExpr compRes = new VWCompiledExpr();
            VWWorkflowSignature partialSignatureTagExprCompile = new VWWorkflowSignature(null, -1, null, this.tag, tagType, this.fields, mapNames, null, this.getRosterName(), this.getEventLogName(), this.getDescription(), this.getName(), this.getBaseWorkClassName());
            String[] theErrorStrings = VWExpr.compileVWExpr(this.tag, partialSignatureTagExprCompile, this.getBaseWorkflowSignature(validationContext), null, null, true, compRes);
            if (theErrorStrings == null || theErrorStrings.length <= 0) {
                tagType = compRes.getResultType();
            }
        }
        VWWorkflowSignature myWflSignature = new VWWorkflowSignature(null, null, this.tag, tagType, (VWFieldDefinition[])this.fieldsHandler.getElements(this.fields), mapNames, null, this.getRosterName(), this.getEventLogName(), this.getDescription(), this.getMilestoneNames(), this.getRulesetNames(), this.getPartnerlinkNames(), this.getSchemaNames(), this.getName(), -1, false, this.getBaseWorkClassName(), this.versionAgnostic);
        if (validationContext != null) {
            validationContext.updateFieldDefinitions(myWflSignature);
        }
        return myWflSignature;
    }

    public VWAttributeInfo getAttributeInfo() throws VWException {
        return this.attributes;
    }

    public void setAttributeInfo(VWAttributeInfo theAttributeInfo) throws VWException {
        this.attributes = theAttributeInfo;
    }

    public VWWorkflowRuntimeId getRuntimeId() {
        return this.runtimeId;
    }

    public boolean getDisableEmailNotification() {
        return this.disableEmailNotification;
    }

    public void setDisableEmailNotification(boolean bFlag) {
        this.disableEmailNotification = bFlag;
    }

    protected void setRuntimeId(VWWorkflowRuntimeId id) {
        this.runtimeId = id;
    }

    protected Hashtable getAttributes() throws VWException {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.attributes;
    }

    protected void setAttributes(Hashtable theAttributeHT) throws VWException {
        if (this.attributes == null) {
            this.attributes = new VWAttributeInfo();
        }
        this.attributes.attributes = theAttributeHT;
    }

    protected String[] getAttributeNames() throws VWException {
        if (this.attributes == null) {
            return null;
        }
        return VWAttributeInfo.getAttributeNames(this.attributes.attributes);
    }

    public VWRuleSetDefinition[] getRuleSets() throws VWException {
        return (VWRuleSetDefinition[])this.ruleSetsHandler.getElements(this.ruleSets);
    }

    public VWRuleSetDefinition createRuleSet(String theValue) throws VWException {
        VWRuleSetDefinition newRuleSet = new VWRuleSetDefinition(this, theValue);
        this.ruleSets = (VWRuleSetDefinition[])this.ruleSetsHandler.addElementToArray(this.ruleSets, newRuleSet);
        return newRuleSet;
    }

    public void deleteRuleSet(VWRuleSetDefinition theRuleSet) throws VWException {
        this.deleteRuleSet(theRuleSet.getName());
    }

    public void deleteRuleSet(String theRuleSetName) throws VWException {
        int deleteIndex = this.ruleSetsHandler.getIndexFromStringFieldValue(this.ruleSets, "m_Name", theRuleSetName);
        this.ruleSetsHandler.deleteElementFromArray(this.ruleSets, deleteIndex);
        VWMapDefinition[] m = this.getMaps();
        if (m != null) {
            for (int i = 0; i < m.length; ++i) {
                VWMapNode[] s = m[i].getSteps();
                if (s == null) continue;
                for (int j = 0; j < s.length; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        s[j].deleteRuleFromRuleList(k, theRuleSetName);
                    }
                }
            }
        }
    }

    protected boolean isExistingRuleSet(String theValue) throws VWException {
        int index = this.ruleSetsHandler.getIndexFromStringFieldValue(this.ruleSets, "m_Name", theValue);
        return index != -1;
    }

    public void setIncomingWSAttachmentFolder(String inAttachmentFolder) throws VWException {
        this.incomingWSAttachmentFolder = inAttachmentFolder;
    }

    public String getIncomingWSAttachmentFolder() {
        return this.incomingWSAttachmentFolder;
    }

    public void setVersionAgnostic(boolean theAgnosticFlag) {
        this.versionAgnostic = theAgnosticFlag;
    }

    public boolean getVersionAgnostic() {
        return this.versionAgnostic;
    }

    public void setValidateUsingSchema(boolean theValidateUsingSchemaFlag) {
        this.validateUsingSchema = theValidateUsingSchemaFlag;
    }

    public boolean getValidateUsingSchema() {
        return this.validateUsingSchema;
    }

    public void setValidateFlag(boolean theValidateFlag) {
        this.validateFlag = theValidateFlag;
    }

    public boolean getValidateFlag() {
        return this.validateFlag;
    }

    public void setTransferFlag(boolean theTransferFlag) {
        this.transferFlag = theTransferFlag;
    }

    public boolean getTransferFlag() {
        return this.transferFlag;
    }

    public Object clone() {
        try {
            return this.makeFlattenedWF(null, this);
        }
        catch (VWException vWException) {
            return null;
        }
    }

    private VWWorkflowDefinition makeFlattenedWF(VWWorkflowDefinition parentWF, VWWorkflowDefinition childWF) throws VWException {
        VWSchema[] parentS;
        VWSchema[] childS;
        VWMilestoneDefinition[] parentMS;
        VWMilestoneDefinition[] childMS;
        VWRuleSetDefinition[] parentRS;
        VWRuleSetDefinition[] childRS;
        VWMapDefinition[] parentMaps;
        VWMapDefinition[] childMaps;
        VWFieldDefinition[] parentFields;
        VWFieldDefinition[] childFields;
        VWPartnerLinkDefinition[] parentPLinks;
        int i;
        VWPartnerLinkDefinition[] childPLinks;
        VWWorkflowDefinition flatWF = new VWWorkflowDefinition(true);
        if (childWF != null) {
            flatWF.setName(childWF.name + "_FLATTENED");
            flatWF.authorTool = childWF.authorTool;
            flatWF.otherAuthorTools = childWF.otherAuthorTools;
            flatWF.deadline = childWF.deadline;
            flatWF.description = childWF.description;
            flatWF.disableEmailNotification = childWF.disableEmailNotification;
            flatWF.incomingWSAttachmentFolder = childWF.incomingWSAttachmentFolder;
            flatWF.mainAttachmentName = childWF.mainAttachmentName;
            flatWF.reminder = childWF.reminder;
            flatWF.subject = childWF.subject;
            flatWF.tag = childWF.tag;
            flatWF.versionAgnostic = childWF.versionAgnostic;
            flatWF.validateUsingSchema = childWF.validateUsingSchema;
            flatWF.validateFlag = childWF.validateFlag;
            flatWF.transferFlag = childWF.transferFlag;
        }
        if (parentWF != null) {
            flatWF.rosterName = parentWF.rosterName;
            flatWF.eventLogName = parentWF.eventLogName;
        }
        flatWF.setBaseWorkClassName(null);
        if (childWF != null && childWF.getRosterName() != null && childWF.getRosterName().length() > 0) {
            flatWF.setRosterName(childWF.getRosterName());
        } else if (parentWF != null && parentWF.getRosterName() != null && parentWF.getRosterName().length() > 0) {
            flatWF.setRosterName(parentWF.getRosterName());
        }
        if (childWF != null && childWF.getEventLogName() != null && childWF.getEventLogName().length() > 0) {
            flatWF.setEventLogName(childWF.getEventLogName());
        } else if (parentWF != null && parentWF.getEventLogName() != null && parentWF.getEventLogName().length() > 0) {
            flatWF.setEventLogName(parentWF.getEventLogName());
        }
        if (childWF != null && (childPLinks = childWF.getPartnerLinks()) != null) {
            for (i = 0; i < childPLinks.length; ++i) {
                flatWF.insertPartnerLink((VWPartnerLinkDefinition)childPLinks[i].clone());
            }
        }
        if (parentWF != null && (parentPLinks = parentWF.getPartnerLinks()) != null) {
            for (i = 0; i < parentPLinks.length; ++i) {
                if (flatWF.isExistingPartnerLinkName(parentPLinks[i].getName())) continue;
                flatWF.insertPartnerLink((VWPartnerLinkDefinition)parentPLinks[i].clone());
            }
        }
        if (childWF != null && (childFields = childWF.getFields()) != null) {
            for (i = 0; i < childFields.length; ++i) {
                flatWF.insertField((VWFieldDefinition)childFields[i].clone());
            }
        }
        if (parentWF != null && (parentFields = parentWF.getFields()) != null) {
            for (i = 0; i < parentFields.length; ++i) {
                if (flatWF.isExistingFieldName(parentFields[i].getName())) continue;
                flatWF.insertField((VWFieldDefinition)parentFields[i].clone());
            }
        }
        if (childWF != null && (childMaps = childWF.getMaps()) != null) {
            for (i = 0; i < childMaps.length; ++i) {
                flatWF.insertMap((VWMapDefinition)childMaps[i].clone());
            }
        }
        if (parentWF != null && (parentMaps = parentWF.getMaps()) != null) {
            for (i = 0; i < parentMaps.length; ++i) {
                if (flatWF.isExistingMapName(parentMaps[i].getName())) continue;
                flatWF.insertMap((VWMapDefinition)parentMaps[i].clone());
            }
        }
        flatWF.syncPartnerLinkReferences();
        if (childWF != null && (childRS = childWF.getRuleSets()) != null) {
            for (i = 0; i < childRS.length; ++i) {
                flatWF.insertRuleSet((VWRuleSetDefinition)childRS[i].clone());
            }
        }
        if (parentWF != null && (parentRS = parentWF.getRuleSets()) != null) {
            for (i = 0; i < parentRS.length; ++i) {
                if (flatWF.isExistingRuleSet(parentRS[i].getName())) continue;
                flatWF.insertRuleSet((VWRuleSetDefinition)parentRS[i].clone());
            }
        }
        if (childWF != null && (childMS = childWF.getMilestones()) != null) {
            for (i = 0; i < childMS.length; ++i) {
                flatWF.insertMilestone((VWMilestoneDefinition)childMS[i].clone());
            }
        }
        if (parentWF != null && (parentMS = parentWF.getMilestones()) != null) {
            for (i = 0; i < parentMS.length; ++i) {
                if (flatWF.isExistingMilestoneName(parentMS[i].getName())) continue;
                flatWF.insertMilestone((VWMilestoneDefinition)parentMS[i].clone());
            }
        }
        if (childWF != null && (childS = childWF.getSchemas()) != null) {
            for (i = 0; i < childS.length; ++i) {
                flatWF.insertSchema((VWSchema)childS[i].clone());
            }
        }
        if (parentWF != null && (parentS = parentWF.getSchemas()) != null) {
            for (i = 0; i < parentS.length; ++i) {
                if (flatWF.isExistingSchemaName(parentS[i].getName())) continue;
                flatWF.insertSchema((VWSchema)parentS[i].clone());
            }
        }
        flatWF.syncPartnerLinkReferences();
        return flatWF;
    }

    private void syncPartnerLinkReferences() throws VWException {
        VWMapDefinition[] m;
        VWPartnerLinkDefinition[] PLs = this.getPartnerLinks();
        if (PLs != null) {
            for (int i = 0; i < PLs.length; ++i) {
                PLs[i].clearInstnRefs();
            }
        }
        if ((m = this.getMaps()) != null) {
            for (int i = 0; i < m.length; ++i) {
                VWMapNode[] s = m[i].getSteps();
                if (s == null) continue;
                for (int j = 0; j < s.length; ++j) {
                    VWInstructionDefinition[] instns;
                    if (!(s[j] instanceof VWCompoundStepDefinition) || (instns = ((VWCompoundStepDefinition)s[j]).getInstructions()) == null) continue;
                    for (int k = 0; k < instns.length; ++k) {
                        if (instns[k] instanceof VWReceiveInstruction) {
                            ((VWReceiveInstruction)instns[k]).addMeToMyPartnerLinkReferences();
                            continue;
                        }
                        if (!(instns[k] instanceof VWReplyInstruction)) continue;
                        ((VWReplyInstruction)instns[k]).addMeToMyPartnerLinkReferences();
                    }
                }
            }
        }
    }

    protected String getRuleSetNameFromIndex(int index) throws VWException {
        if (index < 0 || index > this.ruleSetsHandler.getElementCount()) {
            return null;
        }
        return this.ruleSets[index].getName();
    }

    public void convertAllRouteConditionsToValidExpressions() throws VWException {
        VWMapDefinition[] m = this.getMaps();
        if (m != null) {
            for (int i = 0; i < m.length; ++i) {
                VWMapNode[] s = m[i].getSteps();
                if (s == null) continue;
                for (int j = 0; j < s.length; ++j) {
                    VWRouteDefinition[] r = m[i].getRoutesBySourceStep(s[j].getStepId());
                    if (r == null) continue;
                    for (int k = 0; k < r.length; ++k) {
                        String serverCondition = r[k].getConditionAsServerString();
                        if (serverCondition == null) continue;
                        r[k].setCondition(serverCondition);
                    }
                }
            }
        }
    }

    public VWWorkflowDefinition getFlattenedCopy(VWSession theSession) throws VWException {
        HashSet<String> parentWorkClassNameList = new HashSet<String>();
        return this.getFlattenedCopy(theSession, parentWorkClassNameList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VWWorkflowDefinition getFlattenedCopy(VWSession theSession, HashSet<String> parentWorkClassNameList) throws VWException {
        VWWorkflowDefinition parentWF = null;
        if (this.myWorkflowCollection != null && this.myWorkflowCollection.isExistingWorkflowName(this.getBaseWorkClassName(), true) && this.myWorkflowCollection.getWorkflow(this.getBaseWorkClassName(), true).getTransferFlag()) {
            String baseWorkClassName = this.getBaseWorkClassName();
            parentWF = this.myWorkflowCollection.getWorkflow(baseWorkClassName, true);
            if (parentWorkClassNameList.contains(baseWorkClassName)) throw new VWException("vw.api.VWWorkflowDefinitionCyclicalInheritance", "A work class cannot inherit from itself either directly or indirectly.");
            parentWorkClassNameList.add(baseWorkClassName);
            parentWF = parentWF.getFlattenedCopy(theSession, parentWorkClassNameList);
            return this.makeFlattenedWF(parentWF, this);
        } else {
            if (theSession == null) return this.makeFlattenedWF(parentWF, this);
            parentWF = theSession.fetchWorkflowDefinition(-1, this.getBaseWorkClassName(), true);
        }
        return this.makeFlattenedWF(parentWF, this);
    }

    protected VWRuleSetDefinition getRuleSetByName(String rsName) throws VWException {
        VWRuleSetDefinition retVal = null;
        for (int i = 0; i < this.ruleSetsHandler.getElementCount(); ++i) {
            if (!this.ruleSets[i].getName().equals(rsName)) continue;
            retVal = this.ruleSets[i];
            break;
        }
        return retVal;
    }

    private void findInheritanceProblem(String theNewBaseWorkClassName, VWValidationContext validationContext) {
        if (validationContext == null) {
            return;
        }
        try {
            this.fetchParentWorkflowSignatures(theNewBaseWorkClassName, validationContext);
        }
        catch (VWException ex) {
            VWString theMessage = new VWString("vw.api.VWWorkflowDefinitionUnsuitableBaseWorkClass", "The base work class name, \"{0}\", is not suitable for this workflow. {1}", theNewBaseWorkClassName, ex.getLocalizedMessage());
            VWValidationError theError = new VWValidationError(6, 1, this.name, null, theMessage.toString(), null);
            validationContext.addValidationError(theError);
        }
    }

    protected ArrayList<VWWorkflowSignature> fetchParentWorkflowSignatures(String parentWorkClassName, VWValidationContext validationContext) throws VWException {
        ArrayList<VWWorkflowSignature> parentList = new ArrayList<VWWorkflowSignature>();
        this.fetchParentWorkflowSignatures(parentWorkClassName, parentList, validationContext);
        return parentList;
    }

    private void fetchParentWorkflowSignatures(String workClassName, ArrayList<VWWorkflowSignature> parentList, VWValidationContext validationContext) throws VWException {
        if (workClassName != null && parentList != null && workClassName.compareTo("WorkObject") != 0) {
            for (int i = 0; i < parentList.size(); ++i) {
                if (workClassName.compareTo(parentList.get(i).getName()) != 0) continue;
                throw new VWException("vw.api.VWWorkflowDefinitionCyclicalInheritanceDetected", "Cyclical inheritance detected.  Please select a different base work class.");
            }
            VWWorkflowSignature signature = this.fetchWorkflowSignature(workClassName, validationContext);
            if (signature != null) {
                parentList.add(signature);
                String parentWorkClassName = signature.getBaseWorkClassName();
                if (parentWorkClassName != null) {
                    this.fetchParentWorkflowSignatures(parentWorkClassName, parentList, validationContext);
                }
            }
        }
    }

    protected VWWorkflowSignature fetchWorkflowSignature(String workClassName, VWValidationContext validationContext) throws VWException {
        VWWorkflowSignature workflowSignature = null;
        if (workClassName != null) {
            VWWorkflowDefinition wflDef;
            if (this.myWorkflowCollection != null && this.myWorkflowCollection.isExistingWorkflowName(workClassName, true) && this.myWorkflowCollection.getWorkflow(workClassName, true).getTransferFlag() && (wflDef = this.myWorkflowCollection.getWorkflow(workClassName, true)) != null) {
                workflowSignature = wflDef.getWorkflowSignature(validationContext);
            }
            if (workflowSignature == null && validationContext.getVWSession() != null) {
                workflowSignature = validationContext.getVWSession().fetchWorkflowSignature(workClassName);
            }
        }
        return workflowSignature;
    }

    private String[] getMilestoneNames() {
        VWMilestoneDefinition[] theMilestoneDefs = null;
        try {
            theMilestoneDefs = this.getMilestones();
        }
        catch (VWException ex) {
            // empty catch block
        }
        if (theMilestoneDefs == null || theMilestoneDefs.length == 0) {
            return null;
        }
        ArrayList<String> theMilestoneNames = new ArrayList<String>();
        for (int i = 0; i < theMilestoneDefs.length; ++i) {
            theMilestoneNames.add(theMilestoneDefs[i].getName());
        }
        return theMilestoneNames.toArray(new String[0]);
    }

    private String[] getRulesetNames() {
        VWRuleSetDefinition[] theRuleSetDefs = null;
        try {
            theRuleSetDefs = this.getRuleSets();
        }
        catch (VWException ex) {
            // empty catch block
        }
        if (theRuleSetDefs == null || theRuleSetDefs.length == 0) {
            return null;
        }
        ArrayList<String> theRuleSetNames = new ArrayList<String>();
        for (int i = 0; i < theRuleSetDefs.length; ++i) {
            theRuleSetNames.add(theRuleSetDefs[i].getName());
        }
        return theRuleSetNames.toArray(new String[0]);
    }

    private String[] getPartnerlinkNames() {
        VWPartnerLinkDefinition[] thePartnerLinkDefs = null;
        try {
            thePartnerLinkDefs = this.getPartnerLinks();
        }
        catch (VWException ex) {
            // empty catch block
        }
        if (thePartnerLinkDefs == null || thePartnerLinkDefs.length == 0) {
            return null;
        }
        ArrayList<String> thePartnerLinkNames = new ArrayList<String>();
        for (int i = 0; i < thePartnerLinkDefs.length; ++i) {
            thePartnerLinkNames.add(thePartnerLinkDefs[i].getName());
        }
        return thePartnerLinkNames.toArray(new String[0]);
    }

    private String[] getSchemaNames() {
        VWSchema[] theSchemas = null;
        try {
            theSchemas = this.getSchemas();
        }
        catch (VWException ex) {
            // empty catch block
        }
        if (theSchemas == null || theSchemas.length == 0) {
            return null;
        }
        ArrayList<String> theSchemaNames = new ArrayList<String>();
        for (int i = 0; i < theSchemas.length; ++i) {
            theSchemaNames.add(theSchemas[i].getName());
        }
        return theSchemaNames.toArray(new String[0]);
    }

    static {
        try {
            XMLHelper.parseDocumentViaDOM(null, null, null, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

